/*
 * Decompiled with CFR 0.152.
 */
package linkchecker.urlfilters;

import java.net.URI;
import java.util.Set;
import linkchecker.Issue;
import linkchecker.Severity;
import linkchecker.WebResource;
import linkchecker.interfaces.URLFilter;

public final class WeirdPaths
implements URLFilter {
    @Override
    public void init(Set<URI> paths) {
    }

    @Override
    public boolean shouldFollow(WebResource from, URI to) {
        String path = to.getPath();
        if (path == null) {
            return true;
        }
        Issue issue = new Issue(Severity.INFO, WeirdPaths.class, "Bizarre Link", "Contains link to with unusual substring: " + to.toASCIIString(), 0, 0);
        if (path.contains("https")) {
            from.addIssue(issue);
        }
        if (path.contains("http")) {
            from.addIssue(issue);
        }
        if (path.contains("//")) {
            from.addIssue(issue);
        }
        return true;
    }
}

