/*
 * Decompiled with CFR 0.152.
 */
package linkchecker.urlfilters;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import linkchecker.WebResource;
import linkchecker.interfaces.URLFilter;

public final class ToFromHosts
implements URLFilter {
    private final Set<String> hosts = new HashSet<String>(8);

    @Override
    public void init(Set<URI> paths) {
        this.hosts.addAll(paths.stream().map(URI::getHost).collect(Collectors.toList()));
    }

    @Override
    public boolean shouldFollow(WebResource from, URI to) {
        String toHost = to.getHost();
        String fromHost = from.getUri().getHost();
        return this.hosts.contains(fromHost) || toHost != null && this.hosts.contains(toHost);
    }
}

