/*
 * Decompiled with CFR 0.152.
 */
package linkchecker.urlfilters;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import linkchecker.Issue;
import linkchecker.Severity;
import linkchecker.WebResource;
import linkchecker.interfaces.URLFilter;

public final class ProtocolErrors
implements URLFilter {
    private final Set<String> hosts = new HashSet<String>(8);

    @Override
    public void init(Set<URI> paths) {
        this.hosts.addAll(paths.stream().map(URI::getHost).collect(Collectors.toList()));
    }

    @Override
    public boolean shouldFollow(WebResource from, URI to) {
        String fromHost = from.getUri().getHost();
        if (!this.hosts.contains(fromHost)) {
            return true;
        }
        String toHost = to.getHost();
        if (toHost == null) {
            return true;
        }
        if (Arrays.asList("schema.org", "data-vocabulary.org", "www.w3.org").contains(toHost)) {
            return true;
        }
        Issue issue = new Issue(Severity.WARNING, ProtocolErrors.class, "Insecure Link", "Link to non-secure uri " + to.toASCIIString(), 0, 0);
        if (Arrays.asList("http", "ftp").contains(to.getScheme())) {
            from.addIssue(issue);
        }
        return true;
    }
}

