/*
 * Decompiled with CFR 0.152.
 */
package linkchecker.urlfilters;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import linkchecker.Issue;
import linkchecker.Severity;
import linkchecker.WebResource;
import linkchecker.interfaces.URLFilter;

public final class MaintainSubPath
implements URLFilter {
    private final Map<String, List<String>> hostPaths = new HashMap<String, List<String>>(8);

    @Override
    public void init(Set<URI> paths) {
        paths.forEach(this::extractHostPathPairs);
    }

    @Override
    public boolean shouldFollow(WebResource from, URI to) {
        if (!this.hostPaths.containsKey(to.getHost())) {
            return true;
        }
        String path = to.getPath();
        if (path.endsWith(".js") || path.endsWith(".css")) {
            return true;
        }
        List<String> validPaths = this.hostPaths.get(to.getHost());
        boolean valid = validPaths.stream().anyMatch(path::startsWith);
        if (!valid) {
            Issue issue = new Issue(Severity.ERROR, MaintainSubPath.class, "Sub-path Error", "Linking to URL missing sub-path " + to.toASCIIString(), 0, 0);
            from.addIssue(issue);
        }
        return valid;
    }

    private void extractHostPathPairs(URI uri) {
        if (uri.getHost() == null) {
            return;
        }
        if (!this.hostPaths.containsKey(uri.getHost())) {
            this.hostPaths.put(uri.getHost(), new ArrayList(3));
        }
        this.hostPaths.get(uri.getHost()).add(uri.getPath() != null ? uri.getPath() : "/");
    }
}

