/*
 * Decompiled with CFR 0.152.
 */
package linkchecker.logger;

import java.io.PrintStream;
import java.net.URI;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import linkchecker.PageClassification;
import linkchecker.WebResource;
import linkchecker.interfaces.Reporter;

public final class TextReporter
implements Reporter {
    private int unchecked = 0;
    private int total = 0;
    private int passed = 0;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(Stream<WebResource> allLinks, PrintStream stream) {
        Stream<String> blocks = allLinks.map(this::countUnchecked).filter(link -> link.countIssues() > 0).map(TextReporter::formatMessage);
        Object object = this.lock;
        synchronized (object) {
            stream.printf("Examined %d Urls%n", this.total - this.unchecked);
            stream.printf("%s were 'correct'.%n", this.passed);
            stream.printf("The following issues were found:%n%n", new Object[0]);
        }
        stream.print(blocks.collect(Collectors.joining("\n")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebResource countUnchecked(WebResource resource) {
        Object object = this.lock;
        synchronized (object) {
            ++this.total;
            if (resource.getType() == PageClassification.UNCHECKED) {
                ++this.unchecked;
            }
            if (resource.countIssues() == 0) {
                ++this.passed;
            }
        }
        return resource;
    }

    private static String formatMessage(WebResource resource) {
        StringBuilder builder = new StringBuilder(512);
        Set<URI> sources = resource.getSources();
        builder.append(resource.getUri()).append("\nLinked From:");
        sources.stream().limit(8L).forEach(source -> builder.append(' ').append(source));
        if (sources.size() > 8) {
            builder.append(" and ").append(sources.size() - 8).append(" others");
        }
        resource.getIssues().forEachOrdered(issue -> builder.append("\n - ").append(issue.getMessage()));
        builder.append('\n');
        return builder.toString();
    }
}

