/*
 * Decompiled with CFR 0.152.
 */
package linkchecker.logger;

import java.io.PrintStream;
import java.net.URI;
import java.util.Comparator;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import linkchecker.Issue;
import linkchecker.Severity;
import linkchecker.WebResource;
import linkchecker.interfaces.Reporter;
import linkchecker.lib.StringUtil;

public final class CheckstyleReporter
implements Reporter {
    private static final Pattern PROTOCOL = Pattern.compile("^[a-z]+?://");
    private PrintStream out = null;

    @Override
    public void report(Stream<WebResource> allLinks, PrintStream stream) {
        this.out = stream;
        this.out.printf("<?xml version=\"1.0\" encoding=\"UTF-8\"?>%n", new Object[0]).printf("<checkstyle version=\"3.5.3\">%n", new Object[0]);
        ((Stream)allLinks.filter(resource -> resource.countIssues() > 0).sequential()).sorted(Comparator.comparing(WebResource::getUri)).forEach(this::formatResource);
        this.out.printf("</checkstyle>%n", new Object[0]);
    }

    private void formatResource(WebResource resource) {
        URI uri = resource.getUri();
        String fileName = uri.getPath().replace('/', '_');
        if (fileName.length() > 1) {
            fileName = fileName.substring(1);
        }
        fileName = uri.getScheme() + '/' + uri.getHost() + '/' + fileName;
        this.out.printf("<file name=\"%s\">%n", StringUtil.escapeXML(PROTOCOL.matcher(fileName).replaceFirst("")));
        resource.getIssues().filter(issue -> issue.getSeverity() != Severity.IGNORE).forEachOrdered(this::formatIssue);
        this.out.printf("</file>%n", new Object[0]);
    }

    private void formatIssue(Issue issue) {
        this.out.printf("\t<error line=\"%d\" column=\"%d\" severity=\"%s\" message=\"%s\" source=\"%s.%s\"/>%n", new Object[]{issue.getLine(), issue.getColumn(), issue.getSeverity(), StringUtil.escapeXML(issue.getMessage()), StringUtil.escapeXML(issue.getCategory()), StringUtil.escapeXML(issue.getType())});
    }
}

