/*
 * Decompiled with CFR 0.152.
 */
package linkchecker.lib;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Optional;

public enum StringUtil {

    private static final String[][] XML_ESCAPES = new String[][]{{"\"", "quot"}, {"&", "amp"}, {"<", "lt"}, {">", "gt"}};
    private static final String[][] HTML_ESCAPES = new String[][]{{"\u00a0", "nbsp"}, {"\u00a1", "iexcl"}, {"\u00a2", "cent"}, {"\u00a3", "pound"}, {"\u00a4", "curren"}, {"\u00a5", "yen"}, {"\u00a6", "brvbar"}, {"\u00a7", "sect"}, {"\u00a8", "uml"}, {"\u00a9", "copy"}, {"\u00aa", "ordf"}, {"\u00ab", "laquo"}, {"\u00ac", "not"}, {"\u00ad", "shy"}, {"\u00ae", "reg"}, {"\u00af", "macr"}, {"\u00b0", "deg"}, {"\u00b1", "plusmn"}, {"\u00b2", "sup2"}, {"\u00b3", "sup3"}, {"\u00b4", "acute"}, {"\u00b5", "micro"}, {"\u00b6", "para"}, {"\u00b7", "middot"}, {"\u00b8", "cedil"}, {"\u00b9", "sup1"}, {"\u00ba", "ordm"}, {"\u00bb", "raquo"}, {"\u00bc", "frac14"}, {"\u00bd", "frac12"}, {"\u00be", "frac34"}, {"\u00bf", "iquest"}, {"\u00c0", "Agrave"}, {"\u00c1", "Aacute"}, {"\u00c2", "Acirc"}, {"\u00c3", "Atilde"}, {"\u00c4", "Auml"}, {"\u00c5", "Aring"}, {"\u00c6", "AElig"}, {"\u00c7", "Ccedil"}, {"\u00c8", "Egrave"}, {"\u00c9", "Eacute"}, {"\u00ca", "Ecirc"}, {"\u00cb", "Euml"}, {"\u00cc", "Igrave"}, {"\u00cd", "Iacute"}, {"\u00ce", "Icirc"}, {"\u00cf", "Iuml"}, {"\u00d0", "ETH"}, {"\u00d1", "Ntilde"}, {"\u00d2", "Ograve"}, {"\u00d3", "Oacute"}, {"\u00d4", "Ocirc"}, {"\u00d5", "Otilde"}, {"\u00d6", "Ouml"}, {"\u00d7", "times"}, {"\u00d8", "Oslash"}, {"\u00d9", "Ugrave"}, {"\u00da", "Uacute"}, {"\u00db", "Ucirc"}, {"\u00dc", "Uuml"}, {"\u00dd", "Yacute"}, {"\u00de", "THORN"}, {"\u00df", "szlig"}, {"\u00e0", "agrave"}, {"\u00e1", "aacute"}, {"\u00e2", "acirc"}, {"\u00e3", "atilde"}, {"\u00e4", "auml"}, {"\u00e5", "aring"}, {"\u00e6", "aelig"}, {"\u00e7", "ccedil"}, {"\u00e8", "egrave"}, {"\u00e9", "eacute"}, {"\u00ea", "ecirc"}, {"\u00eb", "euml"}, {"\u00ec", "igrave"}, {"\u00ed", "iacute"}, {"\u00ee", "icirc"}, {"\u00ef", "iuml"}, {"\u00f0", "eth"}, {"\u00f1", "ntilde"}, {"\u00f2", "ograve"}, {"\u00f3", "oacute"}, {"\u00f4", "ocirc"}, {"\u00f5", "otilde"}, {"\u00f6", "ouml"}, {"\u00f7", "divide"}, {"\u00f8", "oslash"}, {"\u00f9", "ugrave"}, {"\u00fa", "uacute"}, {"\u00fb", "ucirc"}, {"\u00fc", "uuml"}, {"\u00fd", "yacute"}, {"\u00fe", "thorn"}, {"\u00ff", "yuml"}};
    private static final int MIN_ESCAPE = 2;
    private static final int MAX_ESCAPE = 6;
    private static final int RADIX_HEX = 16;
    private static final int RADIX_DECIMAL = 10;
    private static final HashMap<CharSequence, CharSequence> lookupMap = new HashMap(XML_ESCAPES.length + HTML_ESCAPES.length);
    private static final HashMap<Character, CharSequence> htmlEncodeMap;
    private static final HashMap<Character, CharSequence> xmlEncodeMap;

    public static CharSequence escapeHTML(CharSequence input) {
        int length = input.length();
        StringWriter writer = new StringWriter(length);
        int horizonStart = 0;
        for (int cursor = 0; cursor < length; ++cursor) {
            char charAtCursor = input.charAt(cursor);
            if (!htmlEncodeMap.containsKey(Character.valueOf(charAtCursor))) continue;
            writer.append(input, horizonStart, cursor);
            writer.append('&').append(htmlEncodeMap.get(Character.valueOf(charAtCursor))).append(';');
            horizonStart = cursor + 1;
        }
        writer.append(input, horizonStart, length);
        return writer.toString();
    }

    public static CharSequence escapeXML(CharSequence input) {
        int length = input.length();
        StringWriter writer = new StringWriter(length);
        int horizonStart = 0;
        for (int cursor = 0; cursor < length; ++cursor) {
            char charAtCursor = input.charAt(cursor);
            if (!xmlEncodeMap.containsKey(Character.valueOf(charAtCursor))) continue;
            writer.append(input, horizonStart, cursor);
            writer.append('&').append(xmlEncodeMap.get(Character.valueOf(charAtCursor))).append(';');
            horizonStart = cursor + 1;
        }
        writer.append(input, horizonStart, length);
        return writer.toString();
    }

    public static CharSequence unEscapeHtml(CharSequence input) {
        StringWriter writer = new StringWriter(input.length());
        int len = input.length();
        int st = 0;
        block0: for (int i = 0; i < len; ++i) {
            if (input.charAt(i) != '&') continue;
            int lim = Math.min(len, i + 6);
            for (int j = i + 2; j < lim; ++j) {
                if (input.charAt(j) != ';') continue;
                Optional<CharSequence> value = StringUtil.getCharacter(input.subSequence(i + 1, j));
                if (!value.isPresent()) continue block0;
                writer.append(input, st, i);
                writer.append(value.get());
                i = j + 1;
                st = j + 1;
                continue block0;
            }
        }
        writer.append(input.subSequence(st, len));
        return writer.toString();
    }

    private static Optional<CharSequence> getCharacter(CharSequence entity) {
        Optional<CharSequence> value;
        if (entity.charAt(1) == '#') {
            char firstChar = entity.charAt(2);
            int radix = 10;
            if (firstChar == 'x' || firstChar == 'X') {
                radix = 16;
            }
            try {
                int entityValue = Integer.parseInt(entity.toString().substring(3), radix);
                value = Optional.of(new String(Character.toChars(entityValue)));
            }
            catch (NumberFormatException ex) {
                value = Optional.empty();
            }
        } else {
            value = Optional.ofNullable(lookupMap.get(entity));
        }
        return value;
    }

    static {
        for (String[] seq : XML_ESCAPES) {
            lookupMap.put(seq[1].toString(), seq[0]);
        }
        for (String[] seq : HTML_ESCAPES) {
            lookupMap.put(seq[1].toString(), seq[0]);
        }
        xmlEncodeMap = new HashMap(XML_ESCAPES.length);
        htmlEncodeMap = new HashMap(XML_ESCAPES.length + HTML_ESCAPES.length);
        for (String[] seq : XML_ESCAPES) {
            if (seq[0].length() != 1) continue;
            htmlEncodeMap.put(Character.valueOf(seq[0].charAt(0)), seq[1]);
            xmlEncodeMap.put(Character.valueOf(seq[0].charAt(0)), seq[1]);
        }
        for (String[] seq : HTML_ESCAPES) {
            if (seq[0].length() != 1) continue;
            htmlEncodeMap.put(Character.valueOf(seq[0].charAt(0)), seq[1]);
        }
    }
}

