/*
 * Decompiled with CFR 0.152.
 */
package linkchecker.deferredfilters;

import java.net.URI;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import linkchecker.Issue;
import linkchecker.PageClassification;
import linkchecker.Severity;
import linkchecker.WebResource;
import linkchecker.interfaces.DeferredFilter;
import linkchecker.interfaces.ResourceSource;

public final class LinkToRedirects
implements DeferredFilter {
    private final Set<String> hosts = new HashSet<String>(8);

    @Override
    public void init(Set<URI> paths) {
        this.hosts.addAll(paths.stream().map(URI::getHost).collect(Collectors.toList()));
    }

    @Override
    public void analyse(Stream<WebResource> resources, ResourceSource source) {
        resources.filter(resource -> resource.getType() == PageClassification.REDIRECT).forEach(resource -> this.markRedirectionIssues((WebResource)resource, source));
    }

    private void markRedirectionIssues(WebResource resource, ResourceSource source) {
        Issue issue = new Issue(Severity.WARNING, LinkToRedirects.class, "Link to Redirect", "Link found to " + resource.getUri() + " should be " + resource.getLocation(), 0, 0);
        resource.getSources().stream().filter(this::matchesHost).map(source::getResource).filter(Optional::isPresent).map(Optional::get).forEach(origin -> origin.addIssue(issue));
    }

    private boolean matchesHost(URI resource) {
        return this.hosts.contains(resource.getHost());
    }
}

