/*
 * Decompiled with CFR 0.152.
 */
package linkchecker.contentfilters;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import linkchecker.WebResource;
import linkchecker.interfaces.ContentFilter;

public class StoreContents
implements ContentFilter {
    private final Set<String> hosts = new HashSet<String>(8);

    @Override
    public final void init(Set<URI> paths) {
        this.hosts.addAll(paths.stream().map(URI::getHost).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    public void examineContents(InputStream content, WebResource resource) {
        URI uri = resource.getUri();
        String fileName = uri.getPath().replace('/', '_');
        if (fileName.startsWith("_out_link_") || fileName.startsWith("_out_mobile_")) {
            return;
        }
        if (fileName.length() > 1) {
            fileName = fileName.substring(1);
        }
        fileName = uri.getScheme() + '/' + uri.getHost() + '/' + fileName;
        try {
            File file = new File(fileName);
            file.getParentFile().mkdirs();
            file.createNewFile();
            Files.copy(content, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

