/*
 * Decompiled with CFR 0.152.
 */
package linkchecker.contentfilters;

import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import linkchecker.WebResource;
import linkchecker.interfaces.ContentFilter;

public abstract class SelfHostHTMLOnlyContentFilter
implements ContentFilter {
    private final Set<String> hosts = new HashSet<String>(8);

    protected SelfHostHTMLOnlyContentFilter() {
    }

    @Override
    public final void init(Set<URI> paths) {
        this.hosts.addAll(paths.stream().map(URI::getHost).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    public final void examineContents(InputStream content, WebResource resource) {
        String resourceHost = resource.getUri().getHost();
        if (!resource.getContentType().startsWith("text/html")) {
            return;
        }
        if (resourceHost == null) {
            return;
        }
        if (this.hosts.stream().noneMatch(host -> SelfHostHTMLOnlyContentFilter.isHostMatching(host, resourceHost))) {
            return;
        }
        this.actualCheckContents(content, resource);
    }

    private static boolean isHostMatching(String desiredHost, String observedHost) {
        return desiredHost.equalsIgnoreCase(observedHost) || observedHost.endsWith('.' + desiredHost);
    }

    protected abstract void actualCheckContents(InputStream var1, WebResource var2);
}

