/*
 * Decompiled with CFR 0.152.
 */
package linkchecker.contentfilters;

import java.io.InputStream;
import linkchecker.Issue;
import linkchecker.Severity;
import linkchecker.WebResource;
import linkchecker.contentfilters.SelfHostHTMLOnlyContentFilter;
import nu.validator.messages.MessageEmitter;
import nu.validator.messages.MessageEmitterAdapter;
import nu.validator.messages.MessageTextHandler;
import nu.validator.messages.types.MessageType;
import nu.validator.source.SourceCode;
import nu.validator.validation.SimpleDocumentValidator;
import nu.validator.xml.SystemErrErrorHandler;
import org.xml.sax.InputSource;

public final class NuValidator
extends SelfHostHTMLOnlyContentFilter {
    @Override
    protected void actualCheckContents(InputStream content, WebResource resource) {
        try {
            InputSource source = new InputSource(content);
            SimpleDocumentValidator validator = new SimpleDocumentValidator(true, false, false);
            MessageEmitterAdapter adapter = new MessageEmitterAdapter(null, new SourceCode(), false, null, 0, true, new LinkCheckerMessageCollector(resource));
            validator.setUpMainSchema("http://s.validator.nu/html5-all.rnc", new SystemErrErrorHandler());
            validator.setUpValidatorAndParsers(adapter, false, false);
            adapter.start(resource.getUri().toASCIIString());
            adapter.setErrorsOnly(false);
            validator.checkHtmlInputSource(source);
        }
        catch (Exception ex) {
            Issue issue = new Issue(Severity.ERROR, NuValidator.class, "Parse Error", "Error validating HTML: " + ex.getMessage(), 0, 0);
            resource.addIssue(issue);
        }
    }

    private static final class MessageBufferHandler
    implements MessageTextHandler {
        private final StringBuilder message;

        MessageBufferHandler(StringBuilder message) {
            this.message = message;
        }

        @Override
        public void characters(char[] chars, int start, int length) {
            this.message.append(chars, start, length);
        }

        @Override
        public void startCode() {
            this.message.append('`');
        }

        @Override
        public void endCode() {
            this.message.append('`');
        }

        @Override
        public void startLink(String href, String title) {
            this.message.append('[').append(href).append('|');
        }

        @Override
        public void endLink() {
            this.message.append(']');
        }
    }

    private static final class LinkCheckerMessageCollector
    extends MessageEmitter {
        private final WebResource resource;
        private final StringBuilder message;
        private MessageType messageType;
        private int line;
        private int col;

        LinkCheckerMessageCollector(WebResource resource) {
            this.resource = resource;
            this.message = new StringBuilder(500);
            this.messageType = null;
            this.line = 0;
            this.col = 0;
        }

        @Override
        public void startMessage(MessageType type, String systemId, int starLine, int startCol, int endLine, int endCol, boolean exact) {
            this.line = starLine;
            this.col = startCol;
            this.messageType = type;
            this.message.setLength(0);
        }

        @Override
        public MessageTextHandler startText() {
            return new MessageBufferHandler(this.message);
        }

        @Override
        public void endMessage() {
            String type;
            Severity severity;
            String messageString = this.message.toString();
            switch (this.messageType.getSuperType()) {
                case "non-document-error": {
                    severity = Severity.ERROR;
                    type = String.valueOf(this.messageType.getPresentationName());
                    break;
                }
                case "info": {
                    severity = "warning".equals(this.messageType.getSubType()) ? Severity.WARNING : Severity.INFO;
                    type = messageString.startsWith("CSS:") ? "CSS" : "HTML";
                    break;
                }
                default: {
                    severity = Severity.ERROR;
                    type = messageString.startsWith("CSS:") ? "CSS" : "HTML";
                }
            }
            this.resource.addIssue(new Issue(severity, NuValidator.class, type, messageString, this.line, this.col));
        }
    }
}

