/*
 * Decompiled with CFR 0.152.
 */
package linkchecker.contentfilters;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.regex.Pattern;
import linkchecker.Issue;
import linkchecker.Severity;
import linkchecker.WebResource;
import linkchecker.contentfilters.SelfHostHTMLOnlyContentFilter;
import linkchecker.lib.StringUtil;

public final class NoCDNSources
extends SelfHostHTMLOnlyContentFilter {
    private static final Pattern URI_PATTERN = Pattern.compile("\\ssrc=\"(?:https?:)?//[^\"]+", 2);

    @Override
    protected void actualCheckContents(InputStream content, WebResource resource) {
        try (Scanner scanner = new Scanner(content, StandardCharsets.UTF_8.name());){
            CharSequence potential;
            while ((potential = scanner.findWithinHorizon(URI_PATTERN, 0)) != null) {
                potential = StringUtil.unEscapeHtml(potential);
                Issue issue = new Issue(Severity.WARNING, NoCDNSources.class, "Non-LazyLoaded src", "Found protocol link in src attribute, should be lazy loaded:" + potential, 0, 0);
                resource.addIssue(issue);
            }
        }
    }
}

