/*
 * Decompiled with CFR 0.152.
 */
package linkchecker;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import linkchecker.Issue;
import linkchecker.PageClassification;
import linkchecker.Severity;

public final class WebResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final int HTTP_OK = 200;
    static final int HTTP_REDIRECT_BLOCK = 300;
    static final int HTTP_CLIENT_ERROR_BLOCK = 400;
    static final int HTTP_SERVER_ERROR_BLOCK = 500;
    static final int CONNECT_TIMEOUT = 2500;
    static final int READ_TIMEOUT = 12000;
    private final URI uri;
    private final Set<URI> sources = new HashSet<URI>(32);
    private final Set<URI> targets = new HashSet<URI>(32);
    private final Set<String> unresolved = new HashSet<String>(32);
    private final List<Issue> issues = new ArrayList<Issue>(8);
    private PageClassification type;
    private int statusCode;
    private String contentType;
    private URI location;
    private int contentLength;

    static boolean isStatusRedirect(int statusCode) {
        return statusCode >= 300 && statusCode < 400;
    }

    static boolean isStatusError(int statusCode) {
        return statusCode >= 400;
    }

    public WebResource(URI target) {
        this.uri = target;
        this.type = PageClassification.UNCHECKED;
        this.statusCode = 0;
        this.contentLength = 0;
        this.contentType = null;
        this.location = null;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof WebResource) {
            return ((WebResource)other).getUri().equals(this.uri);
        }
        return false;
    }

    public Optional<InputStream> fetch() {
        InputStream dataStream = null;
        String locationHeader = null;
        try {
            URL url = this.uri.toURL();
            URLConnection baseConn = url.openConnection();
            if (baseConn instanceof HttpURLConnection) {
                HttpURLConnection conn = (HttpURLConnection)baseConn;
                conn.setConnectTimeout(2500);
                conn.setReadTimeout(12000);
                conn.setInstanceFollowRedirects(false);
                conn.connect();
                this.setStatusCode(conn.getResponseCode());
                this.contentType = conn.getContentType();
                this.contentLength = conn.getContentLength();
                locationHeader = conn.getHeaderField("Location");
                dataStream = conn.getInputStream();
            }
        }
        catch (MalformedURLException ex) {
            this.addFatalIssue("IO Error", "Malformed URL " + this.uri);
        }
        catch (UnknownHostException ex) {
            this.addFatalIssue("IO Error", "Error on " + this.uri + ": " + ex.getMessage());
            this.setStatusCode(404);
        }
        catch (IOException ex) {
            this.addFatalIssue("IO Error", "Error opening " + this.uri + ": " + ex.getMessage());
            this.setStatusCode(503);
        }
        if (WebResource.isStatusRedirect(this.statusCode)) {
            if (locationHeader == null) {
                this.type = PageClassification.ERROR;
            } else {
                this.type = PageClassification.REDIRECT;
                this.handleRedirect(locationHeader);
            }
        }
        return Optional.ofNullable(dataStream);
    }

    private void handleRedirect(String locationHeader) {
        try {
            URI next = this.uri.resolve(locationHeader);
            this.targets.add(next);
            this.location = next;
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            this.type = PageClassification.ERROR;
            this.location = null;
            this.addFatalIssue("Invalid Location Header", "Unable to resolve Location Header in redirect (code " + this.statusCode + ", Location: " + locationHeader + ", Error: " + ex + ')');
        }
    }

    private void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        this.type = PageClassification.UNKNOWN;
        if (statusCode == 200) {
            this.type = PageClassification.SUCCESS;
        }
        if (WebResource.isStatusRedirect(statusCode)) {
            this.type = PageClassification.REDIRECT;
        }
        if (WebResource.isStatusError(statusCode)) {
            if (statusCode >= 500) {
                this.addFatalIssue("HTTP 5XX", "Page not failed to load (status " + statusCode + ')');
            } else {
                this.addFatalIssue("HTTP 4XX", "Page not found (status " + statusCode + ')');
            }
            this.type = PageClassification.ERROR;
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public PageClassification getType() {
        return this.type;
    }

    public String getContentType() {
        return this.contentType;
    }

    public URI getLocation() {
        return this.location;
    }

    public int countSources() {
        return this.sources.size();
    }

    public Set<URI> getSources() {
        return Collections.unmodifiableSet(this.sources);
    }

    public int countIssues() {
        return this.issues.size();
    }

    public Stream<Issue> getIssues() {
        return this.issues.stream();
    }

    boolean addSource(WebResource source) {
        return this.sources.add(source.getUri());
    }

    boolean addTarget(WebResource followed) {
        return this.targets.add(followed.getUri());
    }

    boolean addFatalIssue(String reason, String details) {
        return this.issues.add(new Issue(Severity.ERROR, "linkchecker.FatalError", reason, details, 0, 0));
    }

    public boolean addIssue(Issue issue) {
        return this.issues.add(issue);
    }

    public String toString() {
        return String.format("%s - Status %d %s (%s, %db) with %d issues. Referrers: %d, References: %d", this.uri, this.statusCode, this.type.name(), this.contentType, this.contentLength, this.issues.size(), this.sources.size(), this.targets.size());
    }
}

