/*
 * Decompiled with CFR 0.152.
 */
package linkchecker;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import linkchecker.URLProcessor;

public final class UserInputThread
extends Thread {
    private final BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
    private final URLProcessor processor;

    UserInputThread(URLProcessor processor) {
        super("UserInputThread");
        this.processor = processor;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        while (!this.isInterrupted()) {
            try {
                String line = this.reader.readLine();
                if (line == null) break;
                if ("status".equalsIgnoreCase(line)) {
                    this.printStatus();
                }
                if ("stats".equalsIgnoreCase(line)) {
                    this.printStats();
                }
                if (!"quit".equalsIgnoreCase(line)) continue;
                this.shutdown();
            }
            catch (IOException ex) {
                Logger.getLogger(UserInputThread.class.getName()).log(Level.SEVERE, "Error reading user input", ex);
            }
        }
    }

    void printStatus() {
        this.processor.printStatus(System.err);
    }

    void printStats() {
        this.processor.printStats(System.err);
    }

    void shutdown() {
        this.processor.shutdown();
    }
}

