/*
 * Decompiled with CFR 0.152.
 */
package linkchecker;

import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import linkchecker.PageClassification;
import linkchecker.URLProcessingThread;
import linkchecker.WebResource;
import linkchecker.interfaces.BaseFilter;
import linkchecker.interfaces.ContentFilter;
import linkchecker.interfaces.DeferredFilter;
import linkchecker.interfaces.ResourceSource;
import linkchecker.interfaces.URLFilter;

final class URLProcessor
extends ThreadGroup
implements ResourceSource {
    static final Logger LOGGER = Logger.getLogger(URLProcessor.class.getName());
    public static final long QUEUE_TIMEOUT = 10L;
    private final AtomicInteger threadCounter = new AtomicInteger();
    private final ArrayBlockingQueue<WebResource> queue = new ArrayBlockingQueue(256000);
    private final Map<URI, WebResource> history = new HashMap<URI, WebResource>(1000000);
    private final List<URLFilter> urlFilters = new ArrayList<URLFilter>(8);
    private final List<ContentFilter> contentFilters = new ArrayList<ContentFilter>(8);
    private final List<DeferredFilter> deferredFilters = new ArrayList<DeferredFilter>(8);
    private final Set<String> schemes = new HashSet<String>(8);
    private final Object lock = new Object();

    URLProcessor() {
        super("URLProcessors");
        this.schemes.add("http");
        this.schemes.add("https");
        this.schemes.add("ftp");
        this.schemes.add("file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebResource submit(URI originalTarget, WebResource source) {
        WebResource link;
        boolean previouslySubmitted;
        URI target = URLProcessor.getSanitisedUri(originalTarget);
        Map<URI, WebResource> map = this.history;
        synchronized (map) {
            previouslySubmitted = this.history.containsKey(target);
            if (previouslySubmitted) {
                link = this.history.get(target);
            } else {
                link = new WebResource(target);
                this.history.put(target, link);
            }
        }
        if (source != null) {
            link.addSource(source);
            source.addTarget(link);
        }
        if (this.schemes.contains(target.getScheme()) && !previouslySubmitted) {
            try {
                boolean failed;
                while (failed = !this.queue.offer(link, 10L, TimeUnit.SECONDS)) {
                }
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.WARNING, "Timeout attempting to queue " + link, ex);
            }
        }
        return link;
    }

    private static URI getSanitisedUri(URI uri) {
        if (uri.getFragment() == null) {
            return uri;
        }
        URI sanitised = null;
        try {
            sanitised = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), null);
        }
        catch (URISyntaxException ex) {
            LOGGER.log(Level.SEVERE, "Error removing fragment from URL", ex);
        }
        return Optional.ofNullable(sanitised).orElse(uri);
    }

    void startThreads(int count) {
        for (int i = 0; i < count; ++i) {
            URLProcessingThread newThread = new URLProcessingThread(this, this.threadCounter.incrementAndGet(), Collections.unmodifiableList(this.urlFilters), Collections.unmodifiableList(this.contentFilters));
            newThread.start();
        }
    }

    void shutdown() {
        while (this.activeCount() > 0) {
            try {
                this.queue.clear();
                this.interrupt();
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForCompletion() {
        while (this.activeCount() > 0) {
            try {
                URLProcessor uRLProcessor = this;
                synchronized (uRLProcessor) {
                    if (this.activeCount() > 0) {
                        this.wait(10L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    Stream<WebResource> stream() {
        return this.history.values().parallelStream();
    }

    void offerFilter(BaseFilter filter) {
        if (filter instanceof URLFilter) {
            this.urlFilters.add((URLFilter)filter);
        }
        if (filter instanceof ContentFilter) {
            this.contentFilters.add((ContentFilter)filter);
        }
        if (filter instanceof DeferredFilter) {
            this.deferredFilters.add((DeferredFilter)filter);
        }
    }

    void printStatus(PrintStream out) {
        int processed = this.history.size();
        int pending = this.queue.size();
        out.print(processed - pending + " processed\n");
        out.print(processed + " pending\n");
    }

    void printStats(PrintStream out) {
        Map<PageClassification, Long> buckets = this.stream().collect(Collectors.groupingBy(WebResource::getType, Collectors.counting()));
        long all = buckets.values().stream().reduce(0L, Long::sum);
        out.println("Examined        " + (all - buckets.getOrDefault((Object)PageClassification.UNCHECKED, 0L)));
        out.println("=====");
        out.println("Broken (5XX):   " + buckets.getOrDefault((Object)PageClassification.ERROR, 0L));
        out.println("Redirect (3XX): " + buckets.getOrDefault((Object)PageClassification.REDIRECT, 0L));
        out.println("Failed:         " + buckets.getOrDefault((Object)PageClassification.UNKNOWN, 0L));
        out.println("=====");
        out.println("To Check:       " + buckets.getOrDefault((Object)PageClassification.UNCHECKED, 0L));
    }

    public WebResource poll() throws InterruptedException {
        return this.queue.poll(10L, TimeUnit.SECONDS);
    }

    @Override
    public Optional<WebResource> getResource(URI uri) {
        return Optional.ofNullable(this.history.get(uri));
    }

    public void processDeferredFilters() {
        this.deferredFilters.parallelStream().forEach(filter -> filter.analyse(this.history.values().parallelStream(), this));
    }
}

