/*
 * Decompiled with CFR 0.152.
 */
package linkchecker;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import linkchecker.URLProcessor;
import linkchecker.UserInputThread;
import linkchecker.interfaces.BaseFilter;
import linkchecker.logger.CheckstyleReporter;

public final class LinkChecker {
    private static final Logger LOGGER = Logger.getLogger(LinkChecker.class.getName());
    public static final int DEFAULT_THREAD_COUNT = 16;
    private final Collection<String> namespaces = new HashSet<String>(8);
    private final Set<URI> urls;
    private final Set<Class<BaseFilter>> filters;
    private final URLProcessor processor = new URLProcessor();
    private int threadCount = 16;

    public static void main(String ... args) {
        if (args.length < 2) {
            System.err.println("args: [--count=<thread count>] [--namespace=<namespace> ...] <filter> [<filter> ...] <url> [<url> ...]");
            System.exit(1);
        }
        LinkChecker checker = new LinkChecker(args, System.err);
        checker.run();
    }

    private static <T extends BaseFilter> Optional<T> instantiate(Class<? extends T> clazz) {
        Optional<T> value;
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            value = Optional.of(constructor.newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException | RuntimeException ex) {
            System.err.printf("Error instantiating %s: %s%n", clazz.getName(), ex.getMessage());
            value = Optional.empty();
        }
        return value;
    }

    public LinkChecker(String[] args, PrintStream log) {
        this.urls = new HashSet<URI>(args.length);
        this.filters = new HashSet<Class<BaseFilter>>(args.length);
        this.namespaces.add("");
        this.namespaces.add("linkchecker.urlfilters.");
        this.namespaces.add("linkchecker.contentfilters.");
        Arrays.stream(args).forEachOrdered(this::processArg);
        log.printf("Threads: %d%n", this.threadCount);
        this.filters.stream().map(LinkChecker::instantiate).filter(Optional::isPresent).map(Optional::get).peek(x -> x.init(this.urls)).peek(x -> log.printf("Filter: %s\n", x)).forEach(this.processor::offerFilter);
    }

    public void run() {
        new UserInputThread(this.processor).start();
        this.processor.startThreads(this.threadCount);
        this.processor.waitForCompletion();
        this.processor.processDeferredFilters();
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream("data.ser"));){
            out.writeObject(this.processor.stream().collect(Collectors.toList()));
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Error serialising output data", ex);
        }
        CheckstyleReporter reporter = new CheckstyleReporter();
        try (PrintStream outputStream = new PrintStream("report.txt", StandardCharsets.UTF_8.name());){
            reporter.report(this.processor.stream(), outputStream);
        }
        catch (FileNotFoundException | UnsupportedEncodingException ex) {
            LOGGER.log(Level.SEVERE, "Error writing report", ex);
        }
    }

    private Optional<Class<BaseFilter>> getClass(String filterClass) {
        return this.namespaces.stream().map(namespace -> LinkChecker.getClass(namespace, filterClass)).filter(Optional::isPresent).findAny().orElseGet(Optional::empty);
    }

    private static Optional<Class<BaseFilter>> getClass(String namespace, String clazz) {
        Optional<Class<BaseFilter>> value = Optional.empty();
        try {
            Class<?> classData = Class.forName(namespace + clazz);
            if (BaseFilter.class.isAssignableFrom(classData)) {
                value = Optional.of(classData);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return value;
    }

    private void processArg(String arg) {
        if (arg.startsWith("--count=")) {
            this.threadCount = Integer.parseInt(arg.replace("--count=", ""));
        } else if (arg.startsWith("--namespace=")) {
            String namespace = arg.replace("--namespace=", "");
            if (namespace.endsWith(".")) {
                this.namespaces.add(namespace);
            } else {
                this.namespaces.add(namespace + '.');
            }
        } else {
            Optional<Class<BaseFilter>> clazz = this.getClass(arg);
            if (clazz.isPresent()) {
                this.filters.add(clazz.get());
            } else {
                try {
                    URI uri = new URI(arg);
                    System.err.printf("URL: %s%n", uri.toASCIIString());
                    this.processor.submit(uri, null);
                    this.urls.add(uri);
                }
                catch (URISyntaxException ex) {
                    System.err.print("Invalid URL: ");
                    System.err.println(arg);
                }
            }
        }
    }
}

